<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');
    protected $fillable = array('name', 'image', 'category_id', 'price', 'discount_price', 'description', 'provider_id', 'quantity');

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function provider()
    {
        return $this->belongsTo('App\Models\Provider');
    }

    public function photos()
    {
        return $this->morphMany('App\Models\Photo', 'photable');
    }

}